﻿// ================================================================================================
// Copyright (c) 2012 All Rights Reserved
// Licensed Materials - Property of Zero One
// 
// (c) Copyright Zero One SAS - 2023
// ================================================================================================

using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;

namespace Assets.Scripts
{
    /// <summary>
    /// A custom logger that won't log anything in prod builds
    /// </summary>
    public static class ZoLogger
    {
        private static bool canLog = true; // Debug.isDebugBuild;

        public static void Log(object message)
        {
            if (canLog)
            {
                Debug.Log(message);
            }
        }

		public static void Log(Color color, object message)
		{
			if (canLog)
			{
				Debug.Log("<color=" + ZOColor.ColorToHex(color) + ">" + message + "</color>");
			}
		}

		public static void LogWarning(object message)
        {
            if (canLog)
            {
                Debug.LogWarning(message);
            }
        }

		public static void LogError(object message)
		{
			if (canLog)
			{
				Debug.LogError(message);
			}
		}

		public static void LogException(System.Exception e)
        {
            if (canLog)
            {
                Debug.LogError(e.Message);
                Debug.LogWarning(e.StackTrace);
                System.Console.WriteLine(e.Message);
            }
        }
    }
}
